(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/src/utils/cookies.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "deleteCookie",
    ()=>deleteCookie,
    "getCookie",
    ()=>getCookie,
    "getDismissedAnnouncements",
    ()=>getDismissedAnnouncements,
    "getDismissedOffers",
    ()=>getDismissedOffers,
    "saveDismissedAnnouncements",
    ()=>saveDismissedAnnouncements,
    "saveDismissedOffers",
    ()=>saveDismissedOffers,
    "setCookie",
    ()=>setCookie
]);
function setCookie(name, value) {
    let hours = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 2;
    const date = new Date();
    date.setTime(date.getTime() + hours * 60 * 60 * 1000);
    const expires = "expires=".concat(date.toUTCString());
    document.cookie = "".concat(name, "=").concat(encodeURIComponent(value), ";").concat(expires, ";path=/");
}
function getCookie(name) {
    const nameEQ = "".concat(name, "=");
    const cookies = document.cookie.split(";");
    for(let i = 0; i < cookies.length; i++){
        let cookie = cookies[i];
        while(cookie.charAt(0) === " "){
            cookie = cookie.substring(1);
        }
        if (cookie.indexOf(nameEQ) === 0) {
            return decodeURIComponent(cookie.substring(nameEQ.length));
        }
    }
    return null;
}
function deleteCookie(name) {
    document.cookie = "".concat(name, "=;expires=Thu, 01 Jan 1970 00:00:00 GMT;path=/");
}
function getDismissedAnnouncements() {
    const dismissedCookie = getCookie("dismissedAnnouncements");
    if (!dismissedCookie) {
        return new Set();
    }
    try {
        const dismissedIds = JSON.parse(dismissedCookie);
        return new Set(dismissedIds);
    } catch (error) {
        console.error("Error parsing dismissed announcements cookie:", error);
        return new Set();
    }
}
function saveDismissedAnnouncements(dismissedIds) {
    const dismissedArray = Array.from(dismissedIds);
    setCookie("dismissedAnnouncements", JSON.stringify(dismissedArray), 2);
}
function getDismissedOffers() {
    const dismissedCookie = getCookie("dismissedOffers");
    if (!dismissedCookie) {
        return new Set();
    }
    try {
        const dismissedIds = JSON.parse(dismissedCookie);
        return new Set(dismissedIds);
    } catch (error) {
        console.error("Error parsing dismissed offers cookie:", error);
        return new Set();
    }
}
function saveDismissedOffers(dismissedIds) {
    const dismissedArray = Array.from(dismissedIds);
    setCookie("dismissedOffers", JSON.stringify(dismissedArray), 2);
}
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/components/CookiesBar.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$cookie$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Cookie$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/cookie.js [app-client] (ecmascript) <export default as Cookie>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/client/app-dir/link.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$utils$2f$cookies$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/utils/cookies.ts [app-client] (ecmascript)");
"use client";
;
;
;
;
const CookiesBar = (param)=>{
    let { setAcceptedCookies } = param;
    const handleAcceptedCookies = ()=>{
        setAcceptedCookies(true);
        // Set cookie for 1 year (365 days * 24 hours)
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$utils$2f$cookies$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["setCookie"])("accepted-cookies", "true", 365 * 24);
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: " fixed bottom-6  left-1/2 -translate-x-1/2    sm:left-6 sm:translate-x-0   w-[95%] sm:max-w-md rounded-xl bg-white dark:bg-[#111111]  border border-gray-200 dark:border-[#ffffff1a] p-4 sm:p-5 z-[1000] font-inter",
        style: {
            boxShadow: "\n          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),\n          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),\n          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),\n          0px 2px 4px -1px rgba(0,0,0,0.12),\n          0px 4px 8px -4px rgba(0,0,0,0.12),\n          0px 8px 12px -4px rgba(0,0,0,0.06)\n        "
        },
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "flex items-start gap-3",
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "flex-shrink-0 mt-0.5",
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$cookie$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Cookie$3e$__["Cookie"], {
                        className: "w-5 h-5 text-[#253237] dark:text-white",
                        strokeWidth: 2
                    }, void 0, false, {
                        fileName: "[project]/src/components/CookiesBar.tsx",
                        lineNumber: 44,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
                }, void 0, false, {
                    fileName: "[project]/src/components/CookiesBar.tsx",
                    lineNumber: 43,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "flex-1 space-y-3",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "space-y-1",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h3", {
                                    className: "text-sm font-semibold text-[#253237] dark:text-white",
                                    children: "We use cookies"
                                }, void 0, false, {
                                    fileName: "[project]/src/components/CookiesBar.tsx",
                                    lineNumber: 51,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                    className: "text-sm text-[#51515E] dark:text-[#eeeef0] leading-relaxed",
                                    children: "We use cookies to personalise and enhance your experience."
                                }, void 0, false, {
                                    fileName: "[project]/src/components/CookiesBar.tsx",
                                    lineNumber: 54,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/src/components/CookiesBar.tsx",
                            lineNumber: 50,
                            columnNumber: 11
                        }, ("TURBOPACK compile-time value", void 0)),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "flex flex-col sm:flex-row gap-2 sm:gap-3",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                    onClick: handleAcceptedCookies,
                                    className: " px-4 py-2  bg-[#253237] hover:bg-[#1a2428]  dark:bg-white dark:hover:bg-gray-100 text-white dark:text-[#253237] text-sm font-medium  rounded-lg  transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-[#253237] focus:ring-offset-2 dark:focus:ring-white dark:focus:ring-offset-[#1a1925]",
                                    style: {
                                        boxShadow: "\n                  0px 0.25px 0.25px 0px rgba(0,0,0,0.24),\n                  0px 0.75px 0.75px 0px rgba(0,0,0,0.12),\n                  0px 1px 1.5px -0.5px rgba(0,0,0,0.12),\n                  0px 2px 4px -1px rgba(0,0,0,0.12)\n                "
                                    },
                                    children: "Accept Cookies"
                                }, void 0, false, {
                                    fileName: "[project]/src/components/CookiesBar.tsx",
                                    lineNumber: 59,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0)),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                    href: "/privacy-policy",
                                    className: " px-4 py-2  text-sm font-medium  text-[#51515E] dark:text-[#eeeef0] hover:text-[#253237] dark:hover:text-white transition-colors duration-200 text-center focus:outline-none focus:ring-2 focus:ring-[#253237] focus:ring-offset-2 dark:focus:ring-white dark:focus:ring-offset-[#1a1925] rounded-lg",
                                    children: "Learn More"
                                }, void 0, false, {
                                    fileName: "[project]/src/components/CookiesBar.tsx",
                                    lineNumber: 82,
                                    columnNumber: 13
                                }, ("TURBOPACK compile-time value", void 0))
                            ]
                        }, void 0, true, {
                            fileName: "[project]/src/components/CookiesBar.tsx",
                            lineNumber: 58,
                            columnNumber: 11
                        }, ("TURBOPACK compile-time value", void 0))
                    ]
                }, void 0, true, {
                    fileName: "[project]/src/components/CookiesBar.tsx",
                    lineNumber: 49,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0))
            ]
        }, void 0, true, {
            fileName: "[project]/src/components/CookiesBar.tsx",
            lineNumber: 42,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0))
    }, void 0, false, {
        fileName: "[project]/src/components/CookiesBar.tsx",
        lineNumber: 19,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
_c = CookiesBar;
const __TURBOPACK__default__export__ = CookiesBar;
var _c;
__turbopack_context__.k.register(_c, "CookiesBar");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/wrappers/CookiesWrapper.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>CookiesWrapper
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$components$2f$CookiesBar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/components/CookiesBar.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$utils$2f$cookies$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/utils/cookies.ts [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
function CookiesWrapper() {
    _s();
    // Default to true (hidden) to prevent flash for accepted users
    const [acceptedCookies, setAcceptedCookies] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(true);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "CookiesWrapper.useEffect": ()=>{
            // Check for cookie on mount
            const cookie = (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$utils$2f$cookies$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getCookie"])("accepted-cookies");
            if (!cookie) {
                // eslint-disable-next-line react-hooks/set-state-in-effect
                setAcceptedCookies(false);
            }
        }
    }["CookiesWrapper.useEffect"], []);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["Fragment"], {
        children: !acceptedCookies && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$src$2f$components$2f$CookiesBar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
            setAcceptedCookies: setAcceptedCookies
        }, void 0, false, {
            fileName: "[project]/src/wrappers/CookiesWrapper.tsx",
            lineNumber: 23,
            columnNumber: 9
        }, this)
    }, void 0, false);
}
_s(CookiesWrapper, "k2p/BoclNxaAtx+8jtTYrx6n8kI=");
_c = CookiesWrapper;
var _c;
__turbopack_context__.k.register(_c, "CookiesWrapper");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/components/LimitedOfferBar.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Box$2f$Box$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Box$3e$__ = __turbopack_context__.i("[project]/node_modules/@mui/material/esm/Box/Box.js [app-client] (ecmascript) <export default as Box>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Typography$2f$Typography$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Typography$3e$__ = __turbopack_context__.i("[project]/node_modules/@mui/material/esm/Typography/Typography.js [app-client] (ecmascript) <export default as Typography>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$useMediaQuery$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__useMediaQuery$3e$__ = __turbopack_context__.i("[project]/node_modules/@mui/material/esm/useMediaQuery/index.js [app-client] (ecmascript) <export default as useMediaQuery>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$styles$2f$useTheme$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__useTheme$3e$__ = __turbopack_context__.i("[project]/node_modules/@mui/material/esm/styles/useTheme.js [app-client] (ecmascript) <export default as useTheme>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/framer-motion/dist/es/render/components/motion/proxy.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$components$2f$AnimatePresence$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/framer-motion/dist/es/components/AnimatePresence/index.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/navigation.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$utils$2f$cookies$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/utils/cookies.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$icons$2f$im$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/react-icons/im/index.mjs [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature(), _s1 = __turbopack_context__.k.signature();
"use client";
;
;
;
;
;
;
;
const DEFAULT_API_BASE_URL = "https://admin.clikkle.com:5100";
function useCountdown(endTime) {
    _s();
    const [remaining, setRemaining] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(0);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "useCountdown.useEffect": ()=>{
            const parse = {
                "useCountdown.useEffect.parse": (t)=>t ? new Date(t).getTime() : 0
            }["useCountdown.useEffect.parse"];
            const target = parse(endTime);
            const tick = {
                "useCountdown.useEffect.tick": ()=>{
                    const now = Date.now();
                    setRemaining(Math.max(0, target - now));
                }
            }["useCountdown.useEffect.tick"];
            tick();
            const id = setInterval(tick, 1000);
            return ({
                "useCountdown.useEffect": ()=>clearInterval(id)
            })["useCountdown.useEffect"];
        }
    }["useCountdown.useEffect"], [
        endTime
    ]);
    const parts = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "useCountdown.useMemo[parts]": ()=>{
            let ms = remaining;
            const days = Math.floor(ms / (24 * 60 * 60 * 1000));
            ms -= days * 24 * 60 * 60 * 1000;
            const hours = Math.floor(ms / (60 * 60 * 1000));
            ms -= hours * 60 * 60 * 1000;
            const minutes = Math.floor(ms / (60 * 1000));
            ms -= minutes * 60 * 1000;
            const seconds = Math.floor(ms / 1000);
            return {
                days,
                hours,
                minutes,
                seconds
            };
        }
    }["useCountdown.useMemo[parts]"], [
        remaining
    ]);
    return parts;
}
_s(useCountdown, "Tk/IBdAiFBzs5gIhqFGoJW/XraU=");
const LimitedOfferBar = (param)=>{
    let { apiBaseUrl = DEFAULT_API_BASE_URL, pageName: explicitPageName } = param;
    _s1();
    var _s = __turbopack_context__.k.signature();
    const pathname = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["usePathname"])();
    const pageName = explicitPageName !== null && explicitPageName !== void 0 ? explicitPageName : pathname;
    const theme = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$styles$2f$useTheme$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__useTheme$3e$__["useTheme"])();
    const isMobile = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$useMediaQuery$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__useMediaQuery$3e$__["useMediaQuery"])(theme.breakpoints.down("sm"));
    const [offers, setOffers] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])([]);
    const [dismissedIds, setDismissedIds] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(new Set());
    const [isLoading, setIsLoading] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(true);
    const [error, setError] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    const [show, setShow] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const lastYRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(0);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LimitedOfferBar.useEffect": ()=>{
            setDismissedIds((0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$utils$2f$cookies$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getDismissedOffers"])());
        }
    }["LimitedOfferBar.useEffect"], []);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LimitedOfferBar.useEffect": ()=>{
            const onScroll = {
                "LimitedOfferBar.useEffect.onScroll": ()=>{
                    const y = window.scrollY;
                    const dirDown = y > lastYRef.current;
                    setShow(dirDown && y > 150);
                    lastYRef.current = y;
                }
            }["LimitedOfferBar.useEffect.onScroll"];
            onScroll();
            window.addEventListener("scroll", onScroll, {
                passive: true
            });
            return ({
                "LimitedOfferBar.useEffect": ()=>window.removeEventListener("scroll", onScroll)
            })["LimitedOfferBar.useEffect"];
        }
    }["LimitedOfferBar.useEffect"], []);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "LimitedOfferBar.useEffect": ()=>{
            const fetchOffers = {
                "LimitedOfferBar.useEffect.fetchOffers": async ()=>{
                    try {
                        setIsLoading(true);
                        setError(null);
                        const res = await fetch("".concat(apiBaseUrl, "/api/limited-offers/active?pageName=").concat(encodeURIComponent(pageName || "")));
                        if (!res.ok) throw new Error("HTTP ".concat(res.status));
                        const data = await res.json();
                        setOffers((data === null || data === void 0 ? void 0 : data.data) || []);
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    } catch (e) {
                        console.error("Error fetching limited offers:", e);
                        setError(e.message);
                        setOffers([]);
                    } finally{
                        setIsLoading(false);
                    }
                }
            }["LimitedOfferBar.useEffect.fetchOffers"];
            fetchOffers();
            const id = setInterval(fetchOffers, 5 * 60 * 1000);
            return ({
                "LimitedOfferBar.useEffect": ()=>clearInterval(id)
            })["LimitedOfferBar.useEffect"];
        }
    }["LimitedOfferBar.useEffect"], [
        apiBaseUrl,
        pageName
    ]);
    const visibleOffers = offers.filter((o)=>!dismissedIds.has(o._id));
    if (isLoading || error || visibleOffers.length === 0) return null;
    const OfferItem = (param)=>{
        let { offer } = param;
        _s();
        const { days, hours, minutes, seconds } = useCountdown(offer.endTime);
        const accent = offer.accentColor || "#0B0C0E";
        const expired = days === 0 && hours === 0 && minutes === 0 && seconds === 0;
        if (expired) return null;
        return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Box$2f$Box$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Box$3e$__["Box"], {
            sx: {
                backgroundColor: "transparent",
                color: theme.palette.text.primary,
                borderTop: "1px solid ".concat(theme.palette.divider),
                py: {
                    xs: 1,
                    md: 1.25
                },
                px: {
                    xs: 1.25,
                    md: 3
                },
                display: "flex",
                alignItems: "center",
                width: "100%",
                justifyContent: "center",
                gap: {
                    xs: 1.25,
                    md: 2
                },
                flexDirection: isMobile ? "column" : "row",
                boxShadow: theme.palette.mode === "dark" ? "0 -6px 12px rgba(0,0,0,0.4)" : "0 -6px 12px rgba(0,0,0,0.06)"
            },
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Typography$2f$Typography$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Typography$3e$__["Typography"], {
                    sx: {
                        fontWeight: 800,
                        fontSize: {
                            xs: 15,
                            md: 20
                        },
                        fontFamily: "var(--font-inter), sans-serif"
                    },
                    children: offer.title || "Special Offer Closing In..."
                }, void 0, false, {
                    fileName: "[project]/src/components/LimitedOfferBar.tsx",
                    lineNumber: 143,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Box$2f$Box$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Box$3e$__["Box"], {
                    sx: {
                        display: "flex",
                        alignItems: "center",
                        gap: {
                            xs: 1,
                            md: 2
                        },
                        justifyContent: "center"
                    },
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Box$2f$Box$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Box$3e$__["Box"], {
                        sx: {
                            display: "flex",
                            alignItems: "center",
                            gap: {
                                xs: 1,
                                md: 2
                            },
                            flexWrap: "wrap"
                        },
                        children: [
                            {
                                value: days,
                                label: "days"
                            },
                            {
                                value: hours,
                                label: "hours"
                            },
                            {
                                value: minutes,
                                label: "minutes"
                            },
                            {
                                value: seconds,
                                label: "seconds"
                            }
                        ].map((d)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Box$2f$Box$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Box$3e$__["Box"], {
                                sx: {
                                    minWidth: 56,
                                    px: 1.5,
                                    py: 1,
                                    height: 70,
                                    borderRadius: 1.5,
                                    border: "1px solid ".concat(theme.palette.divider),
                                    backgroundColor: "bg-white dark:bg-[#1a1924]",
                                    display: "flex",
                                    flexDirection: "column",
                                    alignItems: "center",
                                    justifyContent: "center",
                                    boxShadow: theme.palette.mode === "dark" ? "0 1px 4px rgba(0,0,0,0.6)" : "0 1px 4px rgba(0,0,0,0.08)"
                                },
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$components$2f$AnimatePresence$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["AnimatePresence"], {
                                        mode: "popLayout",
                                        initial: false,
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["motion"].div, {
                                            initial: {
                                                rotateX: -90,
                                                opacity: 0
                                            },
                                            animate: {
                                                rotateX: 0,
                                                opacity: 1
                                            },
                                            exit: {
                                                rotateX: 90,
                                                opacity: 0
                                            },
                                            transition: {
                                                duration: 0.4
                                            },
                                            style: {
                                                transformOrigin: "bottom"
                                            },
                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Typography$2f$Typography$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Typography$3e$__["Typography"], {
                                                sx: {
                                                    fontSize: 18,
                                                    fontWeight: 800,
                                                    lineHeight: 1
                                                },
                                                children: d.value
                                            }, void 0, false, {
                                                fileName: "[project]/src/components/LimitedOfferBar.tsx",
                                                lineNumber: 203,
                                                columnNumber: 21
                                            }, ("TURBOPACK compile-time value", void 0))
                                        }, d.value, false, {
                                            fileName: "[project]/src/components/LimitedOfferBar.tsx",
                                            lineNumber: 195,
                                            columnNumber: 19
                                        }, ("TURBOPACK compile-time value", void 0))
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/LimitedOfferBar.tsx",
                                        lineNumber: 194,
                                        columnNumber: 17
                                    }, ("TURBOPACK compile-time value", void 0)),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Typography$2f$Typography$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Typography$3e$__["Typography"], {
                                        sx: {
                                            fontSize: 11,
                                            opacity: 0.7
                                        },
                                        children: d.label
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/LimitedOfferBar.tsx",
                                        lineNumber: 210,
                                        columnNumber: 17
                                    }, ("TURBOPACK compile-time value", void 0))
                                ]
                            }, d.label, true, {
                                fileName: "[project]/src/components/LimitedOfferBar.tsx",
                                lineNumber: 174,
                                columnNumber: 15
                            }, ("TURBOPACK compile-time value", void 0)))
                    }, void 0, false, {
                        fileName: "[project]/src/components/LimitedOfferBar.tsx",
                        lineNumber: 160,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
                }, void 0, false, {
                    fileName: "[project]/src/components/LimitedOfferBar.tsx",
                    lineNumber: 152,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Box$2f$Box$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Box$3e$__["Box"], {
                    sx: {
                        display: "flex",
                        alignItems: "center",
                        gap: 1.25,
                        mt: {
                            xs: 1.25,
                            md: 0
                        },
                        width: isMobile ? "100%" : "auto",
                        justifyContent: "center",
                        order: isMobile ? -1 : 0
                    },
                    children: offer.ctaText && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                        onClick: ()=>{
                            try {
                                fetch("".concat(apiBaseUrl, "/api/limited-offers/").concat(offer._id, "/click"), {
                                    method: "POST",
                                    headers: {
                                        "Content-Type": "application/json"
                                    },
                                    body: JSON.stringify({
                                        pageName
                                    })
                                }).catch(()=>{});
                            } catch (e) {}
                            if (offer.ctaUrl) window.open(offer.ctaUrl, "_blank");
                        },
                        className: "cursor-pointer font-inter font-extrabold px-4 md:px-4 py-1.5 rounded-2xl text-white border-2 border-white flex items-center justify-center gap-2",
                        style: {
                            backgroundColor: theme.palette.mode === "dark" ? "#0B0C0E" : "#253237",
                            outline: theme.palette.mode === "dark" ? "2px solid #0B0C0E" : "2px solid #253237",
                            outlineOffset: "2px",
                            width: isMobile ? "100%" : "auto"
                        },
                        children: [
                            offer.ctaText,
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                className: "text-base",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$icons$2f$im$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ImArrowUpRight2"], {}, void 0, false, {
                                    fileName: "[project]/src/components/LimitedOfferBar.tsx",
                                    lineNumber: 250,
                                    columnNumber: 17
                                }, ("TURBOPACK compile-time value", void 0))
                            }, void 0, false, {
                                fileName: "[project]/src/components/LimitedOfferBar.tsx",
                                lineNumber: 249,
                                columnNumber: 15
                            }, ("TURBOPACK compile-time value", void 0))
                        ]
                    }, void 0, true, {
                        fileName: "[project]/src/components/LimitedOfferBar.tsx",
                        lineNumber: 229,
                        columnNumber: 13
                    }, ("TURBOPACK compile-time value", void 0))
                }, void 0, false, {
                    fileName: "[project]/src/components/LimitedOfferBar.tsx",
                    lineNumber: 217,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0))
            ]
        }, void 0, true, {
            fileName: "[project]/src/components/LimitedOfferBar.tsx",
            lineNumber: 124,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0));
    };
    _s(OfferItem, "UK2eXmBbRlg1HgSYuoT7f6LnQe4=", false, function() {
        return [
            useCountdown
        ];
    });
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$Box$2f$Box$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Box$3e$__["Box"], {
        sx: {
            position: "fixed",
            bottom: 0,
            left: 0,
            right: 0,
            zIndex: 1200,
            transform: show ? "translateY(0)" : "translateY(100%)",
            opacity: show ? 1 : 0,
            transition: "transform 300ms ease, opacity 300ms ease",
            backdropFilter: "blur(12px)",
            backgroundColor: theme.palette.mode === "dark" ? "rgba(26,25,36,0.55)" : "rgba(255,255,255,0.6)",
            borderTop: "1px solid ".concat(theme.palette.divider)
        },
        children: visibleOffers.map((offer)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(OfferItem, {
                offer: offer
            }, offer._id, false, {
                fileName: "[project]/src/components/LimitedOfferBar.tsx",
                lineNumber: 279,
                columnNumber: 9
            }, ("TURBOPACK compile-time value", void 0)))
    }, void 0, false, {
        fileName: "[project]/src/components/LimitedOfferBar.tsx",
        lineNumber: 260,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
_s1(LimitedOfferBar, "ogLlLdKEgzW2fceADzR3OrMJTlA=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["usePathname"],
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$styles$2f$useTheme$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__useTheme$3e$__["useTheme"],
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$useMediaQuery$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__useMediaQuery$3e$__["useMediaQuery"]
    ];
});
_c = LimitedOfferBar;
const __TURBOPACK__default__export__ = LimitedOfferBar;
var _c;
__turbopack_context__.k.register(_c, "LimitedOfferBar");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/theme/themeConfig.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "baseThemeOptions",
    ()=>baseThemeOptions,
    "getTheme",
    ()=>getTheme
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$styles$2f$createTheme$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__createTheme$3e$__ = __turbopack_context__.i("[project]/node_modules/@mui/material/esm/styles/createTheme.js [app-client] (ecmascript) <export default as createTheme>");
;
const baseThemeOptions = {
    breakpoints: {
        keys: [
            "xs",
            "sm",
            "md",
            "lg",
            "xl"
        ],
        values: {
            xs: 0,
            sm: 576,
            md: 768,
            lg: 1280,
            xl: 1516
        }
    },
    typography: {
        fontFamily: "Inter, sans-serif",
        button: {
            textTransform: "none"
        }
    },
    components: {
        MuiCssBaseline: {
            styleOverrides: (theme)=>({
                    body: {
                        "&::-webkit-scrollbar, & *::-webkit-scrollbar": {
                            backgroundColor: "transparent",
                            width: "6px"
                        },
                        "&::-webkit-scrollbar-thumb, & *::-webkit-scrollbar-thumb": {
                            borderRadius: 8,
                            backgroundColor: theme.palette.divider
                        },
                        "&::-webkit-scrollbar-thumb:focus, & *::-webkit-scrollbar-thumb:focus": {
                            backgroundColor: "#747775"
                        },
                        "&::-webkit-scrollbar-thumb:active, & *::-webkit-scrollbar-thumb:active": {
                            backgroundColor: "#747775"
                        },
                        "&::-webkit-scrollbar-thumb:hover, & *::-webkit-scrollbar-thumb:hover": {
                            backgroundColor: "#747775"
                        }
                    }
                })
        },
        MuiDivider: {
            styleOverrides: {
                light: {
                    borderColor: "#424242",
                    width: "100%"
                }
            }
        },
        MuiButton: {
            variants: [
                {
                    props: {
                        variant: "contained"
                    },
                    style: (param)=>{
                        let { theme } = param;
                        return {
                            color: theme.palette.common.white
                        };
                    }
                }
            ],
            styleOverrides: {
                root: {
                    textTransform: "none"
                }
            }
        },
        MuiTextField: {
            styleOverrides: {
                root: {
                    marginBottom: "16px"
                }
            }
        },
        MuiMenu: {
            styleOverrides: {
                root: {
                    ".MuiMenu-list": {
                        padding: "5px"
                    },
                    ".MuiButtonBase-root.MuiMenuItem-root": {
                        fontSize: "14px"
                    }
                }
            }
        },
        MuiTab: {
            styleOverrides: {
                root: {
                    textTransform: "capitalize"
                }
            }
        }
    }
};
const darkThemeConfig = {
    background: {
        paper: "#000000",
        default: "#1a1924"
    },
    text: {
        secondary: "#818991"
    },
    divider: "#424242",
    custom: {
        search: {
            main: "#1A1A1A",
            focus: "#2F2F2F"
        },
        border: "#616161",
        hoverColor: "#fff",
        common: "black",
        appsHover: "rgb(39, 46, 58)",
        menu: "#424242",
        cardHover: "#2F2F2F",
        trashCaption: "#2f2e2e",
        selectedCard: "#2f2e2e",
        selectedPanel: "#2f2e2e",
        selectedMove: "#44b5e899",
        response: "white",
        selectedHover: "rgba(255, 255, 255, 0.08)",
        shareHover: "rgba(255, 255, 255, 0.08)",
        uploadButton: "#2F2F2F",
        uploadButtonHover: "#1a1924"
    }
};
const lightThemeConfig = {
    background: {
        paper: "#FFFFFF",
        default: "#FFFFFF"
    },
    divider: "#e7e3e3",
    custom: {
        search: {
            main: "#edf2fc",
            focus: "white"
        },
        border: "#e7e3e3",
        hoverColor: "#45B5E8",
        common: "white",
        color: "rgba(0, 0, 0, 0.87)",
        appsHover: "rgb(232, 240, 254)",
        menu: "#FFFFFF",
        cardHover: "#E1E5EA",
        trashCaption: "#E3E3E3",
        selectedCard: "#c2e7ff",
        selectedMove: "#c2e7ff",
        selectedPanel: "#f2f6fc",
        response: "#2f2e2e",
        selectedHover: "#B3D7EF",
        shareHover: "rgb(140 140 140 / 15%)",
        uploadButton: "#FFF",
        uploadButtonHover: "#EDF2FA"
    }
};
const getTheme = (mode)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$styles$2f$createTheme$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__createTheme$3e$__["createTheme"])({
        ...baseThemeOptions,
        palette: {
            mode,
            primary: {
                main: "#3B84D9"
            },
            ...mode === "light" ? lightThemeConfig : darkThemeConfig
        }
    });
};
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/providers/ThemeProvider.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>Providers
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next-themes/dist/index.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$styles$2f$ThemeProvider$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ThemeProvider$3e$__ = __turbopack_context__.i("[project]/node_modules/@mui/material/esm/styles/ThemeProvider.js [app-client] (ecmascript) <export default as ThemeProvider>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$CssBaseline$2f$CssBaseline$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@mui/material/esm/CssBaseline/CssBaseline.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2d$nextjs$2f$esm$2f$v13$2d$appRouter$2f$appRouterV13$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__AppRouterCacheProvider$3e$__ = __turbopack_context__.i("[project]/node_modules/@mui/material-nextjs/esm/v13-appRouter/appRouterV13.js [app-client] (ecmascript) <export default as AppRouterCacheProvider>");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$theme$2f$themeConfig$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/theme/themeConfig.ts [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
;
;
;
const MuiThemeWrapper = (param)=>{
    let { children } = param;
    _s();
    const { resolvedTheme } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useTheme"])();
    const [mounted, setMounted] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"](false);
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"]({
        "MuiThemeWrapper.useEffect": ()=>{
            setMounted(true);
        }
    }["MuiThemeWrapper.useEffect"], []);
    const theme = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"]({
        "MuiThemeWrapper.useMemo[theme]": ()=>{
            if (!mounted) return (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$theme$2f$themeConfig$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getTheme"])("light");
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$theme$2f$themeConfig$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getTheme"])(resolvedTheme || "light");
        }
    }["MuiThemeWrapper.useMemo[theme]"], [
        resolvedTheme,
        mounted
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$styles$2f$ThemeProvider$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ThemeProvider$3e$__["ThemeProvider"], {
        theme: theme,
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2f$esm$2f$CssBaseline$2f$CssBaseline$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {}, void 0, false, {
                fileName: "[project]/src/providers/ThemeProvider.tsx",
                lineNumber: 28,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0)),
            children
        ]
    }, void 0, true, {
        fileName: "[project]/src/providers/ThemeProvider.tsx",
        lineNumber: 27,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
_s(MuiThemeWrapper, "nFehF9pxPw/nV0qxg7QPKj8G2iY=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useTheme"]
    ];
});
_c = MuiThemeWrapper;
function Providers(param) {
    let { children } = param;
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$mui$2f$material$2d$nextjs$2f$esm$2f$v13$2d$appRouter$2f$appRouterV13$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__AppRouterCacheProvider$3e$__["AppRouterCacheProvider"], {
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$themes$2f$dist$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ThemeProvider"], {
            attribute: "class",
            defaultTheme: "system",
            enableSystem: true,
            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(MuiThemeWrapper, {
                children: children
            }, void 0, false, {
                fileName: "[project]/src/providers/ThemeProvider.tsx",
                lineNumber: 38,
                columnNumber: 9
            }, this)
        }, void 0, false, {
            fileName: "[project]/src/providers/ThemeProvider.tsx",
            lineNumber: 37,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/src/providers/ThemeProvider.tsx",
        lineNumber: 36,
        columnNumber: 5
    }, this);
}
_c1 = Providers;
var _c, _c1;
__turbopack_context__.k.register(_c, "MuiThemeWrapper");
__turbopack_context__.k.register(_c1, "Providers");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/globals/root.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/navigation.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$components$2f$LimitedOfferBar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/components/LimitedOfferBar.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$providers$2f$ThemeProvider$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/providers/ThemeProvider.tsx [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
const RootContainer = (param)=>{
    let { children } = param;
    _s();
    const pathname = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["usePathname"])();
    const transferPaths = [
        "/files-transfer",
        "/esign",
        "/projects",
        "/hr",
        "/files",
        "/chat",
        "/campaigns",
        "/blogs",
        "/privacy-policy",
        "/about",
        "/affiliate-program",
        "/"
    ];
    const isTransferPage = transferPaths.includes(pathname || "");
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$src$2f$providers$2f$ThemeProvider$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("main", {
                className: isTransferPage ? "mt-0" : "",
                children: children
            }, void 0, false, {
                fileName: "[project]/src/globals/root.tsx",
                lineNumber: 28,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0)),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$src$2f$components$2f$LimitedOfferBar$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                pageName: pathname || ""
            }, void 0, false, {
                fileName: "[project]/src/globals/root.tsx",
                lineNumber: 29,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/src/globals/root.tsx",
        lineNumber: 27,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
_s(RootContainer, "xbyQPtUVMO7MNj7WjJlpdWqRcTo=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["usePathname"]
    ];
});
_c = RootContainer;
const __TURBOPACK__default__export__ = RootContainer;
var _c;
__turbopack_context__.k.register(_c, "RootContainer");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/wrappers/Scrollhandler.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>ScrollHandler
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/navigation.js [app-client] (ecmascript)");
var _s = __turbopack_context__.k.signature();
"use client";
;
;
function ScrollHandler() {
    _s();
    const pathname = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["usePathname"])();
    const searchParams = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useSearchParams"])();
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "ScrollHandler.useEffect": ()=>{
            const hash = window.location.hash;
            if (hash) {
                const target = document.getElementById(hash.substring(1));
                if (target) target.scrollIntoView({
                    behavior: "auto"
                });
            } else {
                window.scrollTo({
                    top: 0,
                    behavior: "auto"
                });
            }
        }
    }["ScrollHandler.useEffect"], [
        pathname,
        searchParams
    ]);
    return null;
}
_s(ScrollHandler, "h6p6PpCFmP4Mu5bIMduBzSZThBE=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["usePathname"],
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useSearchParams"]
    ];
});
_c = ScrollHandler;
var _c;
__turbopack_context__.k.register(_c, "ScrollHandler");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/components/ClikkleChat.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>ClikkleChat
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var _s = __turbopack_context__.k.signature();
"use client";
;
function ClikkleChat() {
    _s();
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "ClikkleChat.useEffect": ()=>{
            // Prevent duplicate script injection
            if (document.getElementById("clikkle-chat-script")) {
                return;
            }
            // Add custom CSS for chat button styling
            const styleId = "chat-button-custom-style";
            if (!document.getElementById(styleId)) {
                const style = document.createElement("style");
                style.id = styleId;
                style.textContent = '\n        /* Target the MUI Fab button - the actual chat button */\n        #my-chat-widget-container .MuiFab-root,\n        #my-chat-widget-container button[aria-label="Open chat"] {\n          background-color: #253237 !important;\n          border-radius: 50% !important;\n          box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15) !important;\n          border: 2px solid rgba(255, 255, 255, 0.2) !important;\n          width: 60px !important;\n          height: 60px !important;\n        }\n        \n        #my-chat-widget-container .MuiFab-root:hover,\n        #my-chat-widget-container button[aria-label="Open chat"]:hover {\n          background-color: #1a2529 !important;\n          box-shadow: 0 6px 16px rgba(0, 0, 0, 0.2) !important;\n          border: 2px solid rgba(255, 255, 255, 0.3) !important;\n        }\n        \n        /* Target the MUI Avatar that wraps the icon */\n        #my-chat-widget-container .MuiAvatar-root {\n          background-color: transparent !important;\n        }\n        \n        /* Ensure the SVG icon inside is visible */\n        #my-chat-widget-container .MuiAvatar-img,\n        #my-chat-widget-container img[alt="Chat Logo"] {\n          max-width: 28px !important;\n          max-height: 28px !important;\n          filter: none !important;\n        }\n      ';
                document.head.appendChild(style);
            }
            // 1. Set configuration
            window.$mychat = window.$mychat || {};
            window.$mychat.config = {
                organizationId: "68759a3aafaea16453c5de48",
                widgetId: "660150a45e31ef6b174750e8",
                socketUrl: "https://chat.clikkle.com:9100",
                apiUrl: "https://chat.clikkle.com:9100",
                name: "Wurknest Support",
                position: "bottom-right",
                greetingMessage: "Hello! How can we help you?",
                headerColor: "#007bff",
                userMessageColor: "#007bff",
                userMessageTextColor: "#000000",
                agentMessageColor: "#eee",
                agentMessageTextColor: "#222",
                widgetBackgroundColor: "#fff",
                fontFamily: "sans-serif",
                requirePreChatForm: false,
                isOffline: false,
                autoRespondOffline: true,
                offlineAutoResponseMessage: "Thanks for your message! We'll get back to you soon.",
                chatIconUrl: "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='none' stroke='white' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpath d='M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z'%3E%3C/path%3E%3C/svg%3E",
                startConversationButtonText: "Start a Conversation",
                organizationLogo: "https://cdn.wurknest.com/images/worknest%20app%20icon%20Transprant-01.png"
            };
            // 2. Load script
            const script = document.createElement("script");
            script.id = "clikkle-chat-script";
            script.src = "https://chat.clikkle.com/chat-widget.iife.js";
            script.async = true; // Use async to not block main thread, config is already set
            script.onload = ({
                "ClikkleChat.useEffect": ()=>{
                    console.log("Wurknest Chat: Widget script loaded.");
                }
            })["ClikkleChat.useEffect"];
            script.onerror = ({
                "ClikkleChat.useEffect": (e)=>{
                    console.error("Wurknest Chat: Widget script failed to load.", e);
                }
            })["ClikkleChat.useEffect"];
            document.body.appendChild(script);
            // Cleanup not strictly necessary for singleton widget, but good practice if it were removable
            return ({
                "ClikkleChat.useEffect": ()=>{
                // document.body.removeChild(script); 
                }
            })["ClikkleChat.useEffect"];
        }
    }["ClikkleChat.useEffect"], []);
    return null;
}
_s(ClikkleChat, "OD7bBpZva5O2jO+Puf00hKivP7c=");
_c = ClikkleChat;
var _c;
__turbopack_context__.k.register(_c, "ClikkleChat");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
]);

//# sourceMappingURL=src_1ae26521._.js.map